$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([{
      element: '#tabNFE',
      popover: {
        title: 'Aba de NFE',
        description: 'Aba para fazer a consulta e exportação de NFE.',
        position: 'bottom'
      }
    },
    {
      element: '#tabNFCE',
      popover: {
        title: 'Aba de NFCE',
        description: 'Aba para fazer a consulta e exportação da NFCE',
        position: 'bottom'
      }
    },
    {
      element: '#tabCFE',
      popover: {
        title: 'Aba de CFE',
        description: 'Aba para fazer a consutla e exportação de CFE.',
        position: 'bottom'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.exportacaoFiscalNFE == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, exportacaoFiscalNFE: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.exportacaoFiscalNFCE == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, exportacaoFiscalNFCE: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.exportacaoFiscalCFE == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, exportacaoFiscalCFE: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      if (localStorage.getItem('tabelanfe') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, exportacaoFiscalNFE: novasColunas }))
        $('#tabelaNFE').DataTable().columns().visible(true);
        $('#tabelaNFE').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelanfce') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, exportacaoFiscalNFCE: novasColunas }))
        $('#tabelaNFCE').DataTable().columns().visible(true);
        $('#tabelaNFCE').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, exportacaoFiscalCFE: novasColunas }))
        $('#tabelaCFE').DataTable().columns().visible(true);
        $('#tabelaCFE').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('tabelanfe') == 'true') {
      $('#tabelaNFE').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.exportacaoFiscalNFE ?? [], ['SEL'])
    } else if (localStorage.getItem('tabelanfce') == 'true') {
      $('#tabelaNFCE').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.exportacaoFiscalNFCE ?? [], ['SEL'])
    } else {
      $('#tabelaCFE').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.exportacaoFiscalCFE ?? [], ['SEL'])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('tabelanfe')
    localStorage.removeItem('tabelanfce')
    localStorage.removeItem('tabelacfe')
  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  Date.prototype.toDateInputValue = (function () {
    var local = new Date(this);
    local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
    return local.toJSON().slice(0, 10);
  });

  dtAtual = new Date().toDateInputValue();

  //AÇÕES NFE
  $('#tabNFE').on('click', function () {
    $('#cardNFE').removeClass('d-none');
    $('#cardNFCE').addClass('d-none');
    $('#cardCFE').addClass('d-none');
  });

  $('#btnFiltrosNFE').on('click', function () {
    $('#modalFiltrosNFE').modal('show');
  });

  $('#modalFiltrosNFE').on('show.bs.modal', function () {
    $("#tabelaEmissao").DataTable().columns.adjust().draw(false);
  })

  $('#rgEntradas, #rgSaidas').on('change', async function () {
    const empIds = $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)).join(', ')
      : getCookie('emp_id')
    $('#btnLimpaNotaNFE').trigger('click')

    $('#btnNotaNFE').unbind();
    if ($('#rgEntradas').is(':checked')) {
      $('#divEntradas').removeClass('d-none')
      $('#divEntradas').addClass('d-flex')
      $('#divSaidas').removeClass('d-flex')
      $('#divSaidas').addClass('d-none')
      componenteFiltro('notaEntra', true, true, 'NotaNFE', [` NOTA_ENTRA.EMP_ID IN (${empIds})`])
    } else {
      $('#divEntradas').addClass('d-none')
      $('#divEntradas').removeClass('d-flex')
      $('#divSaidas').addClass('d-flex')
      $('#divSaidas').removeClass('d-none')
      componenteFiltro('nota', true, true, 'NotaNFE', [` NOTA.EMP_ID IN (${empIds})`])
    }
  });

  $('#modal-empresas').on('hide.bs.modal', function () {
    const empIds = $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)).join(', ')
      : getCookie('emp_id')

    if ($('#rgEntradas').is(':checked')) {
      componenteFiltro('notaEntra', true, true, 'NotaNFE', [` NOTA_ENTRA.EMP_ID IN (${empIds})`])
    } else {
      componenteFiltro('nota', true, true, 'NotaNFE', [` NOTA.EMP_ID IN (${empIds})`])
    }
  })

  $("#btnLimpaNotaNFE").on("click", function () { $("#txtNotaNFE").val("") });

  $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":["NATUREZA CHAVE, DESCRICAO"], "where": null}`);
  $("#btnNaturezaNFE").pesquisa_serverside(["#txtNaturezaNFE"], ["NATUREZA"], ["DESCRICAO"], '{"tabela":"natureza", "camposSelect":["NATUREZA", "DESCRICAO"], "where": null}', "Pesquisa Natureza");
  $('#btnLimpaNaturezaNFE').on('click', function () { $('#txtNaturezaNFE').val("") });

  $("#txtClienteNFE").autocompleta(3, 'JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}');
  $("#btnClienteNFE").pesquisa_serverside(["#txtClienteNFE"], ["CODCLI", "CNPJ"], ["NOME", "CNPJ"], '{"tabela":"entidade", "camposSelect":["CODCLI", "NOME", "FANTASIA", "CNPJ"], "where": null}', "Pesquisa Cliente");
  $("#btnLimpaClienteNFE").on("click", function () { $("#txtClienteNFE").val("") });

  $("#txtVendedorNFE").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
  $("#btnVendedorNFE").pesquisa_serverside(["#txtVendedorNFE"], ["CODREP"], ["NOME"], '{"tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"], "where": null}', "Pesquisa Vendedor");
  $("#btnLimpaVendedorNFE").on("click", function () { $("#txtVendedorNFE").val("") });

  $("#txtGrupoClienteNFE").autocompleta(1, `JSON={ "tabela":"GRUPO_CLI", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $("#btnGrupoClienteNFE").pesquisa_serverside(["#txtGrupoClienteNFE"], ["CODIGO"], ["DESCRICAO"], '{"tabela":"GRUPO_CLI", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}', "Pesquisa Grupo Cliente");
  $("#btnLimpaGrupoClienteNFE").on("click", function () { $("#txtGrupoClienteNFE").val("") });

  $("#txtTransportadoraNFE").autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
  $("#btnTransportadoraNFE").pesquisa_serverside(["#txtTransportadoraNFE"], ["CODIGO"], ["NOME"], '{"tabela":"TABTRAN", "camposSelect":["CODIGO", "NOME"], "where": null}', "Pesquisa Transportadora");
  $("#btnLimpaTransportadoraNFE").on("click", function () { $("#txtTransportadoraNFE").val("") });

  $('#btnLimparFiltrosNFE').on('click', async function () {
    $('#dtEmissaoDe').val('1200-01-01');
    $('#dtEmissaoAte').val('2500-12-31');
    $('#dtSaidaDe').val('1200-01-01');
    $('#dtSaidaAte').val('2500-12-31');
    $('#dtEntradaDe').val('1200-01-01');
    $('#dtEntradaAte').val('2500-12-31');
    $('#dtEntrEmissaoDe').val('1200-01-01');
    $('#dtEntrEmissaoAte').val('2500-12-31');
    $('#btnLimpaNotaNFE').trigger('click');
    $('#txtClienteNFE').val('');
    $('#txtNaturezaNFE').val('');
    $('#txtGrupoClienteNFE').val('');
    $('#txtNaturezaNFE').val('');
    $('#txtVendedorNFE').val('');
    $('#txtTransportadoraNFE').val('');
    $('#txtTransportadoraNFE').val('');
    $('#cbExportaDanfe').prop('checked', false);
    $('#cbNotaInutilizadaNFE').prop('checked', false);
    $('#cbSomenteCanceladasNFE').prop('checked', false);
    $('#cbSomenteInutilizadasNFE').prop('checked', false);
    $('#cbNotaCanceladaNFE').prop('checked', false);
  });

  //AÇÕES NFCE
  $('#tabNFCE').on('click', function () {
    $('#cardNFCE').removeClass('d-none');
    $('#cardNFE').addClass('d-none');
    $('#cardCFE').addClass('d-none');
  });

  $('#btnFiltrosNFCE').on('click', function () {
    $('#modalFiltrosNFCE').modal('show');
  });

  $("#txtNotaNFCE").autocompleta(1, `JSON={ "tabela":"NOTA_NFCE", "camposSelect":["FATURA CHAVE, VALOR DESCRICAO"], "where": ["EMP_ID='${getCookie('emp_id')}'"]}`, [], [], []);
  $("#btnNotaNFCE").pesquisa_array(["#txtNotaNFCE"], ["FATURA"], ["VALOR"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NOTA_NFCE", "camposSelect":[ "FATURA", "VALOR" ], "where":["EMP_ID='${getCookie('emp_id')}'"]}`, "Pesquisa NFCE", "NOTA_NFCE");
  $("#btnLimpaNotaNFCE").on("click", function () { $("#txtNotaNFCE").val("") });

  $("#txtNaturezaNFCE").autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":["NATUREZA CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnNaturezaNFCE').pesquisa('#txtNaturezaNFCE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NATUREZA", "camposSelect":[ "NATUREZA", "DESCRICAO"]}`, 'Pesquisa Natureza', 'NATUREZA');
  $("#btnLimpaNaturezaNFCE").on("click", function () { $("#txtNaturezaNFCE").val("") });

  $("#txtClienteNFCE").autocompleta(3, 'JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}');
  $("#btnClienteNFCE").pesquisa_serverside(["#txtClienteNFCE"], ["CODCLI", "CNPJ"], ["NOME", "CNPJ"], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', "Pesquisa Cliente");
  $("#btnLimpaClienteNFCE").on("click", function () { $("#txtClienteNFCE").val("") });

  $("#txtGrupoClienteNFCE").autocompleta(1, `JSON={ "tabela":"GRUPO_CLI", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $("#btnGrupoClienteNFCE").pesquisa_array(["#txtGrupoClienteNFCE"], ["CODIGO"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', "Pesquisa Grupo Cliente", "GRUPO_CLI");
  $("#btnLimpaGrupoClienteNFCE").on("click", function () { $("#txtGrupoClienteNFCE").val("") });

  $('#btnLimparFiltrosNFCE').on('click', function () {
    $('#dtEmissaoNFCEDe').val('1200-01-01');
    $('#dtEmissaoNFCEAte').val('2500-12-31');
    $('#txtNotaNFCE').val('');
    $('#txtClienteNFCE').val('');
    $('#txtNaturezaNFCE').val('');
    $('#txtGrupoClienteNFCE').val('');
    $('#cbCanceladasNFCE').prop('checked', false);
    $('#cbInutilizadasNFCE').prop('checked', false);
    $('#cbSomenteCanceladasNFCE').prop('checked', false);
    $('#cbSomenteInutilizadasNFCE').prop('checked', false);
  });

  $('#btnLimparFiltrosCFE').on('click', function () {
    $('#cbCfeCanceladas').prop('checked', false);
    $('#cbCfeSomenteCanceladas').prop('checked', false);
    $('#dtEmissaoCFEDe').val('1200-01-01');
    $('#dtEmissaoCFEAte').val('2500-12-31');
  });

  $('#btnFiltrosNFCE').on('click', function () {
    $('#modalFiltrosNFCE').modal('show');
  });

  //AÇÕES CFE
  $('#tabCFE').on('click', function () {
    $('#cardCFE').removeClass('d-none');
    $('#cardNFE').addClass('d-none');
    $('#cardNFCE').addClass('d-none');
  });

  $('#btnFiltrosCFE').on('click', function () {
    $('#modalFiltrosCFE').modal('show');
  });

  $('#txtVendaCFE').autocompleta(1, `JSON={ "tabela":"venda", "camposSelect":[ "codven CHAVE", "nrcupom descricao"], "where": null}`);
  $('#btnVendaCFE').pesquisa('#txtVendaCFE', 'CODVEN', 'NRCUPOM', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"venda", "camposSelect":[ "codven", "nrcupom"]}`, 'Pesquisa Venda', 'venda');
  $('#btnLimpaVendaCFE').on('click', function () { $('#txtVendaCFE').val('') });

  $('#txtClienteCFE').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#btnClienteCFE').pesquisa('#txtClienteCFE', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Cliente', 'entidade');
  $('#btnLimpaClienteCFE').on('click', function () { $('#txtClienteCFE').val('') });

  $('#btnExportarNFE').on('click', async function () {
    if (!$.fn.DataTable.isDataTable("#tabelaNFE")) {
      msgAlerta('Nenhuma nota para exportar.');
      return;
    }
    await exportaNFE();
  });

  $('#btnExportarNFCE').on('click', async function () {
    if (!$.fn.DataTable.isDataTable("#tabelaNFCE")) {
      msgAlerta('Nenhuma nota para exportar.');
      return;
    }
    await exportaNFCE();
  });

  $('#btnExportarCFE').on('click', async function () {
    if (!$.fn.DataTable.isDataTable("#tabelaCFE")) {
      msgAlerta('Nenhuma nota para exportar.');
      return;
    }
    await exportaCFE();
  });

  async function buscaNFE() {
    try {
      params = await buscaParamsNFE();
      const response = await requisicao('GET', '/sisplan/exportafiscal/v1/pesquisanfe?', `JSON=${JSON.stringify(params)}`);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return
      }

      return jsonStr;

    } catch (error) {
      console.error(error);
      msgAlerta(`Nenhuma nota encontrada, verifique!`);
    }
  }

  async function buscaParamsNFE() {
    const obj = {
      ENTRADA_DE: $('#dtEntradaDe').val() != '1200-01-01' ? $('#dtEntradaDe').val() : '1200-01-01',
      ENTRADA_ATE: $('#dtEntradaAte').val() != '2500-12-31' ? $('#dtEntradaAte').val() : '2500-12-31',
      EMISSAO_ENTR_DE: $('#dtEntrEmissaoDe').val() != '1200-01-01' ? $('#dtEntrEmissaoDe').val() : '1200-01-01',
      EMISSAO_ENTR_ATE: $('#dtEntrEmissaoAte').val() != '2500-12-31' ? $('#dtEntrEmissaoAte').val() : '2500-12-31',
      EMISSAO_DE: $('#dtEmissaoDe').val() != '1200-01-01' ? $('#dtEmissaoDe').val() : '1200-01-01',
      EMISSAO_ATE: $('#dtEmissaoAte').val() != '2500-12-31' ? $('#dtEmissaoAte').val() : '2500-12-31',
      SAIDA_DE: $('#dtSaidaDe').val() != '1200-01-01' ? $('#dtSaidaDe').val() : '1200-01-01',
      SAIDA_ATE: $('#dtSaidaAte').val() != '2500-12-31' ? $('#dtSaidaAte').val() : '2500-12-31',
      FATURA: await formataListas($('#txtNotaNFE').val().toString()),
      NATUREZA: pegaChave('#txtNaturezaNFE'),
      CODCLI: pegaChave('#txtClienteNFE'),
      CODREP: pegaChave('#txtVendedorNFE'),
      GRUPO_CLIENTE: pegaChave('#txtGrupoClienteNFE'),
      TRANSPORT: pegaChave('#txtTransportadoraNFE'),
      CANCELADAS: $('#cbNotaCanceladaNFE').is(':checked') ? '1' : '0',
      TIPO_NOTA: $('#rgSaidas').is(':checked') ? '1' : '0',
      INUTILIZADAS: $('#cbNotaInutilizadaNFE').is(':checked') ? '1' : '0',
      SOMENTE_CANCELADAS: $('#cbSomenteCanceladasNFE').is(':checked') ? '1' : '0',
      SOMENTE_INUTILIZADAS: $('#cbSomenteInutilizadasNFE').is(':checked') ? '1' : '0',
      EMP_IDS: $('.empresa_selecionada:checked').toArray().length > 0
        ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)).join(', ')
        : getCookie('emp_id')
    }
    if (obj.ENTRADA_DE == '') {
      obj.ENTRADA_DE = '1200-01-01';
    }
    if (obj.ENTRADA_ATE == '') {
      obj.ENTRADA_ATE = '2500-12-31';
    }
    if (obj.EMISSAO_ENTR_DE == '') {
      obj.EMISSAO_ENTR_DE = '1200-01-01';
    }
    if (obj.EMISSAO_ENTR_ATE == '') {
      obj.EMISSAO_ENTR_ATE = '2500-12-31';
    }
    if (obj.EMISSAO_DE == '') {
      obj.EMISSAO_DE = '1200-01-01';
    }
    if (obj.EMISSAO_ATE == '') {
      obj.EMISSAO_ATE = '2500-12-31';
    }
    if (obj.SAIDA_DE == '') {
      obj.SAIDA_DE = '1200-01-01';
    }
    if (obj.SAIDA_ATE == '') {
      obj.SAIDA_ATE = '2500-12-31';
    }
    return obj;
  }

  async function buscaNFCE() {
    try {
      params = buscaParamsNFCE();
      const response = await requisicao('GET', '/sisplan/exportafiscal/v1/pesquisanfce?', `JSON=${JSON.stringify(params)}`);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return
      }

      return json;

    } catch (error) {
      console.error(error);
      msgAlerta(`Nenhuma nota encontrada, verifique!`);
    }
  }

  function buscaParamsNFCE() {
    const obj = {
      EMISSAO_DE: $('#dtEmissaoNFCEDe').val() != '1200-01-01' ? $('#dtEmissaoNFCEDe').val() : '1200-01-01',
      EMISSAO_ATE: $('#dtEmissaoNFCEAte').val() != '2500-12-31' ? $('#dtEmissaoNFCEAte').val() : '2500-12-31',
      FATURA: pegaChave('#txtNotaNFCE'),
      NATUREZA: pegaChave('#txtNaturezaNFCE'),
      CODCLI: pegaChave('#txtClienteNFCE'),
      GRUPO_CLIENTE: pegaChave('#txtGrupoClienteNFCE'),
      CANCELADAS: $('#cbCanceladasNFCE').is(':checked') ? '1' : '0',
      INUTILIZADAS: $('#cbInutilizadasNFCE').is(':checked') ? '1' : '0',
      SOMENTE_CANCELADAS: $('#cbSomenteCanceladasNFCE').is(':checked') ? '1' : '0',
      SOMENTE_INUTILIZADAS: $('#cbSomenteInutilizadasNFCE').is(':checked') ? '1' : '0',
      EMP_ID: getCookie('emp_id'),
    }
    if (obj.EMISSAO_DE == '') {
      obj.EMISSAO_DE = '1200-01-01';
    }
    if (obj.EMISSAO_ATE == '') {
      obj.EMISSAO_ATE = '2500-12-31';
    }
    return obj;
  }

  async function buscaCFE() {
    try {
      params = buscaParamsCFE();
      const response = await requisicao('GET', '/sisplan/exportafiscal/v1/pesquisacfe?', `JSON=${JSON.stringify(params)}`);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return
      }

      return json;

    } catch (error) {
      console.error(error);
      msgAlerta(`Nenhuma nota encontrada, verifique!`);
    }
  }

  function buscaParamsCFE() {
    const obj = {
      EMISSAO_DE: $('#dtEmissaoCFEDe').val() != '1200-01-01' ? $('#dtEmissaoCFEDe').val() : '1200-01-01',
      EMISSAO_ATE: $('#dtEmissaoCFEAte').val() != '2500-12-31' ? $('#dtEmissaoCFEAte').val() : '2500-12-31',
      CANCELADAS: $('#cbCfeCanceladas').is(':checked') ? '1' : '0',
      SOMENTE_CANCELADAS: $('#cbCfeSomenteCanceladas').is(':checked') ? '1' : '0',
      EMP_ID: getCookie('emp_id'),
    }
    if (obj.EMISSAO_DE == '') {
      obj.EMISSAO_DE = '1200-01-01';
    }
    if (obj.EMISSAO_ATE == '') {
      obj.EMISSAO_ATE = '2500-12-31';
    }
    return obj;
  }

  async function exportaNFE() {
    let iArrayChave = [];
    let iArrayFatura = [];

    iOpcaoCheck = $('#rgEntradas').prop('checked') ? '0' : '1';

    const notasSelecionadas = $(`#tabelaNFE`).DataTable().rows().data().$(`.campoSelNFE`).toArray().filter((campoSel) => $(campoSel).prop('checked'));
    if (notasSelecionadas.length == 0) {
      msgAlerta('Nenhuma nota selecionada.');
      return;
    }
    try {
      $.LoadingOverlay("show");

      notasSelecionadas.forEach((inputSelecionado) => {
        const closestTr = $(inputSelecionado).closest('tr');
        const data = $(`#tabelaNFE`).DataTable().rows(closestTr).data();
        iArrayChave.push(data[0].CHAVE_NFE);
        if (data[0].FATURA != '') {
          iArrayFatura.push(data[0].FATURA);
        }
      });

      const body = {
        chaves: iArrayChave,
        faturas: iArrayFatura,
      }

      const response = await requisicao('POST', `/Sisplan/exportafiscal/V1/exportanfe?`, `TIPO=${iOpcaoCheck}&EXPORTADANFE=${$('#cbExportaDanfe').is(':checked')}`, `${JSON.stringify(body)}`, 500000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
      }
      if (response.status == 200) {
        toastr.success(
          'Arquivo compactado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden: () => window.open(`${BASE_URI}/XML/${jsonStr.mensagem}`)
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      } else {
        return;
      }

    } catch (error) {
      console.log(error)
      msgAlerta('Não foi possivel compactar os arquivos, verifique!');
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function exportaNFCE() {
    let iArrayChave = [];
    let iArrayImpresso = [];

    const NotasSelecionadas = $(`#tabelaNFCE`).DataTable().rows().data().$(`.campoSelNFCE`).toArray().filter((campoSel) => $(campoSel).prop('checked'));
    if (NotasSelecionadas.length == 0) {
      msgAlerta('Nenhuma nota selecionada');
      return;
    }

    try {
      $.LoadingOverlay("show");
      NotasSelecionadas.forEach((inputSelecionado) => {
        const closestTr = $(inputSelecionado).closest('tr');
        const data = $(`#tabelaNFCE`).DataTable().rows(closestTr).data().toArray()
        iArrayImpresso.push(data[0].IMPRESSO);
        iArrayChave.push(data[0].CHAVE_NFCE);
      });

      const body = {
        chaves: iArrayChave,
        impresso: iArrayImpresso,
      }

      const response = await requisicao('POST', `/Sisplan/exportafiscal/V1/exportanfce?`, '', `${JSON.stringify(body)}`, 50000);

      let jsonStr = await response.json();

      if (response.status == 200) {
        toastr.success(
          'Arquivo compactado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden: () => window.open(`${BASE_URI}/XML/${jsonStr.mensagem}`)
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      } else if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
      }

    } catch (error) {
      console.log(error)
      msgAlerta('Não foi possivel compactar os arquivos, verifique!');
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  function buscaDadosCfe() {
    const tabelaCfe = $('#tabelaCFE').DataTable().rows().data().toArray();

    const objeto = tabelaCfe.map((dados) => dados.SEL == 'S' ? ({
      chave: dados.CHAVE_CFE,
    }) : null).filter((dados) => dados !== null)
    return objeto;
  }

  $('#check_todosCFE').on('click', function () {
    selecionarTodosInputsStone()
  });

  function selecionarTodosInputsStone() {
    $(`#tabelaCFE`).DataTable().rows().data().$(`.campoSelCFE`).toArray().filter((campoSel) => {
      if (!$(campoSel).prop('disabled')) {
        $(campoSel).prop('checked', !campoSel.checked)
        $('#tabelaCFE').DataTable().rows(campoSel.closest('tr')).data().toArray()[0].SEL = campoSel.checked ? 'S' : 'N';
      }
    });
  }

  $('#tabelaCFE').on('click', '.campoSelCFE', async function () {
    lineIsChecked = $('#tabelaCFE').DataTable().rows((this).closest('tr')).data().toArray()[0].SEL == 'N' ? true : false
    newValue = lineIsChecked ? 'S' : 'N'
    $('#tabelaCFE').DataTable().rows((this).closest('tr')).data().toArray()[0].SEL = newValue;
  });

  async function exportaCFE() {
    const notasSelecionadas = $(`#tabelaCFE`).DataTable().rows().data().$(`.campoSelCFE`).toArray().filter((campoSel) => $(campoSel).prop('checked'));
    if (notasSelecionadas.length === 0) {
      msgAlerta('Nenhuma nota selecionada');
      return;
    }
    try {
      $.LoadingOverlay('show');
      let Chaves = buscaDadosCfe();


      const chaves = {
        Chaves: Chaves
      }

      const response = await requisicao('POST', '/Sisplan/exportafiscal/V1/exportacfe?', '', JSON.stringify(chaves), 500000);

      if (!response) return;

      const jsonStr = await response.json();

      if (response.status === 200) {
        toastr.success(
          'Arquivo compactado com sucesso!',
          'Confirmação',
          {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: 'toast-top-center',
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden: () => window.open(`${BASE_URI}/XML/${jsonStr.mensagem}`)
          }
        ).css({ 'margin-top': '20%', width: '500px', 'max-width': '500px' });
      } else if (response.status !== 200) {
        return msgAlerta(jsonStr.mensagem);
      }

    } catch (error) {
      console.log(error);
      msgAlerta('Não foi possivel compactar os arquivos, verifique!');
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function selecionarTodosInputs(tipo) {
    if ($(`#check_todos${tipo}`).is(':checked')) {
      $(`#tabela${tipo}`).DataTable().rows().data().$(`.campoSel${tipo}`).toArray().filter((campoSel) => $(campoSel).prop('checked', true))
    } else {
      $(`#tabela${tipo}`).DataTable().rows().data().$(`.campoSel${tipo}`).toArray().filter((campoSel) => $(campoSel).prop('checked', false))
    }
  }

  function insereCampoSel(posicao, tipo) {
    posicao.render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
                    <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel${tipo}">
                    <label for="check_col_${meta.row}_row_${meta.col}"></label>
                </div>`
    }
  }

  $('#btnConsultarNFE').on('click', async function () {
    try {
      $.LoadingOverlay('show')
      if ($.fn.DataTable.isDataTable('#tabelaNFE')) {
        $('#tabelaNFE').DataTable().destroy();
        $('#tabelaNFE').empty();
      };
      let dataSet = await buscaNFE();
      let dataSetCols = [];

      if (dataSet.length > 0) {

        var keys = Object.keys(dataSet[0]);
        dataSetCols.push({
          'title': 'SEL',
          'data': 'SEL',
          'width': '15px'
        });

        insereCampoSel(dataSetCols[0], 'NFE');

        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
          });
        }

        $('#tabelaNFE').DataTable({
          destroy: true,
          serverside: true,
          search: false,
          scrollX: true,
          scrollY: '55vh',
          pageLength: 25,
          autoWidth: true,
          lengthChange: true,
          sortable: true,
          paging: true,
          filter: true,
          info: true,
          order: [],
          destroy: true,
          colReorder: true,
          "data": dataSet,
          "columns": dataSetCols,
          "columnDefs": [{
            className: "dt-head-center"
          },
          {
            targets: [9, 10, 11],
            type: "date-br",
            render(data) {
              if (!data) {
                return '';
              }
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
          },
          {
            "render": function (data) {
              if (data !== null && data !== undefined && !isNaN(data)) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              } else {
                return '0,00';
              }
            },
            "targets": [18],
            "className": 'pr-4 text-right'
          }
          ]
        });

        $('.campoCheck').on('change', function () {
          if (this.checked) {
            $(this).addClass('selecionado');
          } else {
            $(this).removeClass('selecionado');
          }
        });

        $('#tabelaNFE_length').prepend('<button class="buttonColVis" id="buttonColVisNFE"><i class="fas fa-cogs"></i></button>');
        $('#tabelaNFE_length').prepend('<button class="buttonExcel" id="buttonExcelNFE"><i class="fas fa-file-excel"></i></button>');

        $('#buttonExcelNFE').on('click', async function () {
          let dados = $("#tabelaNFE").DataTable().data().toArray();
          await exportaCSV("", "", undefined, null, 'Relatório de Exportação Fiscal - NFE', '#tabelaNFE', '', 999, false, false, dados);
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVisNFE').on('click', async function () {
          $.LoadingOverlay('show')
          try {
            localStorage.setItem('tabelanfe', 'true')
            $('#modal-ColunasVisiveis').modal('show');
          } finally {
            $.LoadingOverlay('hide')
          }
        });

        $('#tabelaNFE').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.exportacaoFiscalNFE).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
      $('#modalFiltrosNFE').modal('hide');
    }
  });

  $('#check_todosNFE').on('change', function () {
    selecionarTodosInputs('NFE');
  });

  $('.campoCheck').on('change', function () {
    if (this.checked) {
      $(this).addClass('selecionado');
    } else {
      $(this).removeClass('selecionado');
    }
  });

  $('#btnConsultarNFCE').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($.fn.DataTable.isDataTable('#tabelaNFCE')) {
        $('#tabelaNFCE').DataTable().destroy();
        $('#tabelaNFCE').empty();
      };
      var dataSet = await buscaNFCE();
      var dataSetCols = [];

      var keys = Object.keys(dataSet[0]);
      dataSetCols.push({
        'title': 'SEL',
        'data': 'SEL',
        'width': '15px'
      });

      insereCampoSel(dataSetCols[0], 'NFCE');

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      $('#tabelaNFCE').DataTable({
        destroy: true,
        serverside: true,
        search: false,
        scrollX: true,
        scrollY: '55vh',
        pageLength: 25,
        autoWidth: true,
        lengthChange: true,
        sortable: true,
        paging: true,
        filter: true,
        info: true,
        order: [],
        destroy: true,
        colReorder: true,
        "data": dataSet,
        "columns": dataSetCols,
        columnDefs: [
          {
            render(data) {
              return parseFloat(data).toLocaleString('pt-br', {
                style: 'currency',
                currency: 'BRL'
              });
            },
            targets: 9,
            className: 'pr-4 text-right'
          },
          {
            type: 'date-br',
            targets: [4],
            render: function (data) {
              if (data != undefined && data != '') {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            }
          },
          {
            type: 'date-br',
            targets: [5],
            render: function (data) {
              if (data != undefined && data != '') {
                x = data.slice(0, 10).split('-');
                hora = data.split(' ')[1]
                if (x[2]) {
                  return `${x[2]}/${x[1]}/${x[0]}`
                } else {
                  return `${x} ${hora} `;
                }
              } else {
                return ''
              }
            }
          }
        ],
      });

      $('#tabelaNFCE_length').prepend('<button class="buttonColVis" id="buttonColVisNFCE"><i class="fas fa-cogs"></i></button>');
      $('#tabelaNFCE_length').prepend('<button class="buttonExcel" id="buttonExcelNFCE"><i class="fas fa-file-excel"></i></button>');

      $('#modalFiltrosNFCE').modal('hide');

      $('#buttonExcelNFCE').on('click', async function () {
        let dados = $("#tabelaNFCE").DataTable().data().toArray();
        await exportaCSV(
          "",
          "",
          undefined,
          null,
          'Relatório de Exportação Fiscal - NFCE',
          '#tabelaNFCE',
          formataCampos(),
          999,
          false,
          false,
          dados);
      })

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVisNFCE').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          localStorage.setItem('tabelanfce', 'true')
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });

      $('#tabelaNFCE').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.exportacaoFiscaNFCE).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } catch (error) {
      console.log(error);

    } finally {
      $.LoadingOverlay('hide');
      $('#modalFiltrosNFCE').modal('hide');
    }
  });

  $('#check_todosNFCE').on('change', function () {
    selecionarTodosInputs('NFCE');
  });

  $('#btnConsultarCFE').on('click', async function () {
    $.LoadingOverlay('show');
    if ($.fn.DataTable.isDataTable('#tabelaCFE')) {
      $('#tabelaCFE').DataTable().destroy();
      $('#tabelaCFE').empty();
    };
    try {
      var dataSet = await buscaCFE();

      dataSetCols = [
        { data: 'SEL', title: 'SEL' },
        { data: 'FATURA', title: 'Fatura' },
        { data: 'SERIE_SAT', title: 'Série Sat.' },
        { data: 'NRCUPOM', title: 'NrCupom' },
        { data: 'DT_EMISSAO', title: 'Data de Emissão' },
        { data: 'IMPRESSO', title: 'Impresso' },
        { data: 'CHAVE_CFE', title: 'Chave Cfe' },
        { data: 'CHAVE_CANC', title: 'Chave Cancelamento' },
        { data: 'CODCLI', title: 'CodCli' },
        { data: 'NOME', title: 'Nome' },
        { data: 'VALOR', title: 'Valor' }
      ];

      insereCampoSel(dataSetCols[0], 'CFE');

      $('#tabelaCFE').DataTable({
        destroy: true,
        serverside: true,
        search: false,
        scrollX: true,
        scrollY: '55vh',
        pageLength: 25,
        autoWidth: true,
        lengthChange: true,
        sortable: true,
        paging: true,
        filter: true,
        info: true,
        order: [],
        destroy: true,
        colReorder: true,
        "data": dataSet,
        "columns": dataSetCols,
        "columnDefs": [
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [10],
            "className": 'pr-4 text-right'
          }]
      });

      $('#tabelaCFE_length').prepend('<button class="buttonColVis" id="buttonColVisCFE"><i class="fas fa-cogs"></i></button>');
      $('#tabelaCFE_length').prepend('<button class="buttonExcel" id="buttonExcelCFE"><i class="fas fa-file-excel"></i></button>');

      $('#buttonExcelCFE').on('click', async function () {
        let dados = $("#tabelaCFE").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório de Exportação Fiscal - CFE', '#tabelaCFE', '', 999, false, false, dados);
      })

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVisCFE').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          localStorage.setItem('tabelacfe', 'true')
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });

      $('#tabelaCFE').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.exportacaoFiscalCFE).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modalFiltrosCFE').modal('hide');
    }
  });

  function formataCampos() {
    retorno =
      "dados = dados.map((key) => { \n" +
      "let v1 = \" \" + key.CHAVE_NFCE; \n" +
      "return {...key, CHAVE_NFCE: v1 } \n" +
      "}) \n";
    return retorno;
  }

  $('#check_todosCFE').on('change', function () {
    selecionarTodosInputs('CFE');
  });

  async function retornaFiltrosNFE() {
    const sEntradaDe = $('#dtEntradaDe').val() != '1200-01-01' ? $('#dtEntradaDe').val() : '1200-01-01';
    const sEntradaAte = $('#dtEntradaAte').val() != '2500-12-31' ? $('#dtEntradaAte').val() : '2500-12-31';
    const sEmissaoEntrDe = $('#dtEntrEmissaoDe').val() != '1200-01-01' ? $('#dtEntrEmissaoDe').val() : '1200-01-01';
    const sEmissaoEntrAte = $('#dtEntrEmissaoAte').val() != '2500-12-31' ? $('#dtEntrEmissaoAte').val() : '2500-12-31';
    const sEmissaoDe = $('#dtEmissaoDe').val() != '1200-01-01' ? $('#dtEmissaoDe').val() : '1200-01-01';
    const sEmissaoAte = $('#dtEmissaoAte').val() != '2500-12-31' ? $('#dtEmissaoAte').val() : '2500-12-31';
    const sSaidaDe = $('#dtSaidaDe').val() != '1200-01-01' ? $('#dtSaidaDe').val() : '1200-01-01';
    const sSaidaAte = $('#dtSaidaAte').val() != '2500-12-31' ? $('#dtSaidaAte').val() : '2500-12-31';
    const sFatura = await formataListas($('#txtNotaNFE').val().toString())
    const sNatureza = pegaChave('#txtNaturezaNFE');
    const sCliente = pegaChave('#txtClienteNFE');
    const sVendedor = pegaChave('#txtVendedorNFE');
    const sGrupoCliente = pegaChave('#txtGrupoClienteNFE');
    const sTransportadora = pegaChave('#txtTransportadoraNFE');
    const sTipoNota = $('#rgSaidas').is(':checked') ? '1' : '0';
    const sOrdem = sTipoNota;
    const sCanceladas = $('#cbNotaCanceladaNFE').is(':checked') ? '1' : '0';
    const sInutilizadas = $('#cbNotaInutilizadaNFE').is(':checked') ? '1' : '0';
    const sSomenteCanceladas = $('#cbSomenteCanceladasNFE').is(':checked') ? '1' : '0';
    const sSomenteInutilizadas = $('#cbSomenteInutilizadasNFE').is(':checked') ? '1' : '0';
    const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

    const retorno =
      `EMISSAO_DE=${sEmissaoDe}` +
      `&EMISSAO_ATE=${sEmissaoAte}` +
      `&SAIDA_DE=${sSaidaDe}` +
      `&SAIDA_ATE=${sSaidaAte}` +
      `&ENTRADA_DE=${sEntradaDe}` +
      `&ENTRADA_ATE=${sEntradaAte}` +
      `&EMISSAO_ENTR_DE=${sEmissaoEntrDe}` +
      `&EMISSAO_ENTR_ATE=${sEmissaoEntrAte}` +
      `&FATURA=${sFatura}` +
      `&NATUREZA=${sNatureza}` +
      `&CODCLI=${sCliente}` +
      `&GRUPO_CLIENTE=${sGrupoCliente}` +
      `&CODREP=${sVendedor}` +
      `&CODTRAN=${sTransportadora}` +
      `&TIPO_NOTA=${sTipoNota}` +
      `&DOC=NFE` +
      `&ORDEM_IMPRESSAO=${sOrdem}` +
      `&CANCELADAS=${sCanceladas}` +
      `&INUTILIZADAS=${sInutilizadas}` +
      `&SOMENTE_CANCELADAS=${sSomenteCanceladas}` +
      `&SOMENTE_INUTILIZADAS=${sSomenteInutilizadas} ` +
      `&EMP_IDS=${listaEmpIds}`;

    return retorno;
  }

  function retornaFiltrosNFCE() {
    const sEmissaoDe = $('#dtEmissaoNFCEDe').val() != '1200-01-01' ? $('#dtEmissaoNFCEDe').val() : '1200-01-01';
    const sEmissaoAte = $('#dtEmissaoNFCEAte').val() != '2500-12-31' ? $('#dtEmissaoNFCEAte').val() : '2500-12-31';
    const sFatura = pegaChave('#txtNotaNFCE') != '' ? pegaChave('#txtNotaNFCE') : '';
    const sNatureza = pegaChave('#txtNaturezaNFCE') != '' ? pegaChave('#txtNaturezaNFCE') : '';
    const sCliente = pegaChave('#txtClienteNFCE') != '' ? pegaChave('#txtClienteNFCE') : '';
    const sGrupoCliente = pegaChave('#txtGrupoClienteNFCE') != '' ? pegaChave('#txtGrupoClienteNFCE') : '';

    const sCanceladas = $('#cbCanceladasNFCE').is(':checked') ? '1' : '0'
    const sInutilizadas = $('#cbInutilizadasNFCE').is(':checked') ? '1' : '0';
    const sSomenteCanceladas = $('#cbSomenteCanceladasNFCE').is(':checked') ? '1' : '0';
    const sSomenteInutilizadas = $('#cbSomenteInutilizadasNFCE').is(':checked') ? '1' : '0';

    const retorno =
      `EMISSAO_DE=${sEmissaoDe}` +
      `&EMISSAO_ATE=${sEmissaoAte}` +
      `&FATURA=${sFatura}` +
      `&NATUREZA=${sNatureza}` +
      `&CODCLI=${sCliente}` +
      `&GRUPO_CLIENTE=${sGrupoCliente}` +
      `&CANCELADAS=${sCanceladas}` +
      `&INUTILIZADAS=${sInutilizadas}` +
      `&SOMENTE_CANCELADAS=${sSomenteCanceladas}` +
      `&SOMENTE_INUTILIZADAS=${sSomenteInutilizadas}` +
      `&DOC=NFCE` +
      `&ORDEM_IMPRESSAO=2`;

    return retorno;
  }

  function retornaFiltrosCFE() {
    const sEmissaoDe = $('#dtEmissaoCFEDe').val() != '1200-01-01' ? $('#dtEmissaoCFEDe').val() : '1200-01-01';
    const sEmissaoAte = $('#dtEmissaoCFEAte').val() != '2500-12-31' ? $('#dtEmissaoCFEAte').val() : '2500-12-31';

    const retorno =
      `EMISSAO_DE=${sEmissaoDe}` +
      `&EMISSAO_ATE=${sEmissaoAte}` +
      `&DOC=CFE` +
      `&ORDEM_IMPRESSAO=3`;

    return retorno;
  }

  $('#btnImprimirNFE').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/imprimirexportafiscal?`;
        const params = await retornaFiltrosNFE();
        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnImprimirNFCE').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/imprimirexportafiscal?`;
        const params = retornaFiltrosNFCE();
        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnImprimirCFE').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/imprimirexportafiscal?`;
        const params = retornaFiltrosCFE();
        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#rgSaidas').click();
  $('#rgEntradas').click();
  $('#rgSaidas').click();

});